// PCanIsoTpExampleDlgParameters.cpp : implementation file
//
#include "stdafx.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CPCanIsoTpExampleDlgParameters dialog

IMPLEMENT_DYNAMIC(CPCanIsoTpExampleDlgParameters, CDialogEx)

CPCanIsoTpExampleDlgParameters::CPCanIsoTpExampleDlgParameters(TPCANTPHandle *p_pctpHandle, CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_PCANISOTPEXAMPLE_TAB_PARAMETERS, pParent)
{
	m_pctpHandle = p_pctpHandle; // Handle selected on combobox Channel
}

void CPCanIsoTpExampleDlgParameters::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_INFO, listBoxParamInfo);
	DDX_Control(pDX, IDC_EDIT_PARAMVALUE, editParamValue);
	DDX_Control(pDX, IDC_BUTTON_CLEAR, buttonParamInfoClear);
	DDX_Control(pDX, IDC_BUTTON_GET, buttonParamGet);
	DDX_Control(pDX, IDC_BUTTON_RESET, buttonParamReset);
	DDX_Control(pDX, IDC_BUTTON_SET, buttonParamSet);
	DDX_Control(pDX, IDC_BUTTON_STATUS, buttonParamStatus);
	DDX_Control(pDX, IDC_BUTTON_VERSION, buttonParamVersion);
	DDX_Control(pDX, IDC_COMBO_PARAM, comboBoxParameter);
	DDX_Control(pDX, IDC_RADIO_ACTIVE, radioButtonParamActive);
	DDX_Control(pDX, IDC_RADIO_INACTIVE, radioButtonParamInactive);
	DDX_Control(pDX, IDC_SPIN_PARAMVALUE, numericUpDownParamValue);

	// --- Initialization of default states and values ---
	// List box "Information"
	listBoxParamInfo.AddString(L"Select a Hardware and a configuration for it.Then click \"Initialize\" button");
	listBoxParamInfo.AddString(L"When activated, configure ISO - TP mappings in order to transmit and receive ISO - TP messages.");
	listBoxParamInfo.AddString(L"---");
	listBoxParamInfo.AddString(L"Note that to successfully transmit ISO - TP messages, you need a valid ISO - TP node to communicate with.");
	listBoxParamInfo.AddString(L"You can run a second instance of this application on another channel to do so.");
	listBoxParamInfo.AddString(L"---");

	radioButtonParamActive.SetCheck(true);
	OnCbnSelchangeComboParam();
}

BEGIN_MESSAGE_MAP(CPCanIsoTpExampleDlgParameters, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_SET, &CPCanIsoTpExampleDlgParameters::OnBnClickedButtonSet)
	ON_BN_CLICKED(IDC_BUTTON_GET, &CPCanIsoTpExampleDlgParameters::OnBnClickedButtonGet)
	ON_CBN_SELCHANGE(IDC_COMBO_PARAM, &CPCanIsoTpExampleDlgParameters::OnCbnSelchangeComboParam)
	ON_BN_CLICKED(IDC_BUTTON_STATUS, &CPCanIsoTpExampleDlgParameters::OnBnClickedButtonStatus)
	ON_BN_CLICKED(IDC_BUTTON_RESET, &CPCanIsoTpExampleDlgParameters::OnBnClickedButtonReset)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, &CPCanIsoTpExampleDlgParameters::OnBnClickedButtonClear)
	ON_BN_CLICKED(IDC_BUTTON_VERSION, &CPCanIsoTpExampleDlgParameters::OnBnClickedButtonVersion)
END_MESSAGE_MAP()

/// <summary>
/// Event handler called when button "Parameters > Set" is clicked.
/// </summary>
void CPCanIsoTpExampleDlgParameters::OnBnClickedButtonSet()
{
	TPCANTPParameter param = 0;
	TPCANTPStatus sts = 0;
	UINT32 iBuf = 0;
	CString strParam = L"";
	CString strTemp = L"";

	// Checks selection is valid.
	if (comboBoxParameter.GetCurSel() == CB_ERR)
		return;

	UINT32 paramValue = numericUpDownParamValue.GetPos32();

	// Sets selected parameter
	param = (TPCANTPParameter)(comboBoxParameter.GetItemData(comboBoxParameter.GetCurSel()));
	switch (param)
	{
		// Sets the ISO-TP BlockSize (BS) parameter (number of Consecutive Frame between Flow Control frames).
	case PCANTP_PARAM_BLOCK_SIZE:
		sts = CANTP_SetValue(*m_pctpHandle, param, &paramValue, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)paramValue });
		break;
		// Sets if CAN DATA Padding is enabled (if enabled, all segmented CAN frames have a DLC of 8).
	case PCANTP_PARAM_CAN_DATA_PADDING:
		iBuf = radioButtonParamActive.GetCheck() ? PCANTP_CAN_DATA_PADDING_ON : PCANTP_CAN_DATA_PADDING_NONE;
		sts = CANTP_SetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)iBuf });
		break;
		// Sets if Debug mode is enabled (if enabled, CAN Tx/Rx frames are echoed on console output).
	case PCANTP_PARAM_DEBUG:
		iBuf = radioButtonParamActive.GetCheck() ? PCANTP_DEBUG_CAN : PCANTP_DEBUG_NONE;
		sts = CANTP_SetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)iBuf });
		break;
		// Sets if Message Pending Mode is enabled
		//  (if enabled, CAN ISO-TP messages with type PCANTP_MESSAGE_INDICATION
		//  can be read when the first frame of a segmented message is received).
	case PCANTP_PARAM_MSG_PENDING:
		iBuf = radioButtonParamActive.GetCheck() ? PCANTP_MSG_PENDING_SHOW : PCANTP_MSG_PENDING_HIDE;
		sts = CANTP_SetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)iBuf });
		break;
		// Sets the padding value used when "CAN DATA Padding" is enabled.
	case PCANTP_PARAM_PADDING_VALUE:
		editParamValue.GetWindowTextW(strParam);
		iBuf = CPCanIsoTpUtils::HexStrToDec(strParam);
		sts = CANTP_SetValue(*m_pctpHandle, param, &paramValue, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)paramValue });
		break;
		// Sets the ISO-TP SeparationTime (STmin) parameter
		//  (minimum time to wait between Consecutive Frames transmission).
	case PCANTP_PARAM_SEPARATION_TIME:
		editParamValue.GetWindowTextW(strParam);
		iBuf = CPCanIsoTpUtils::HexStrToDec(strParam);
		sts = CANTP_SetValue(*m_pctpHandle, param, &paramValue, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)paramValue });
		break;
		// Sets the ISO-TP J1939 Priority
	case PCANTP_PARAM_J1939_PRIORITY:
		editParamValue.GetWindowTextW(strParam);
		iBuf = CPCanIsoTpUtils::HexStrToDec(strParam);
		sts = CANTP_SetValue(*m_pctpHandle, param, &paramValue, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)paramValue });
		break;
		// Sets the ISO-TP Data Length Code (DLC) of the fragmented frames used when transmitting FD messages
	case PCANTP_PARAM_CAN_TX_DL:
		editParamValue.GetWindowTextW(strParam);
		iBuf = CPCanIsoTpUtils::HexStrToDec(strParam);
		sts = CANTP_SetValue(*m_pctpHandle, param, &paramValue, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)paramValue });
		break;
		// Sets the ISO-TP FC.Wait frame transmissions (N_WFTMax) parameter
		//  (maximum number of consecutive Flow Control frames with the Wait status after which transmission is aborted).
	case PCANTP_PARAM_WFT_MAX:
		editParamValue.GetWindowTextW(strParam);
		iBuf = CPCanIsoTpUtils::HexStrToDec(strParam);
		sts = CANTP_SetValue(*m_pctpHandle, param, &paramValue, sizeof(UINT32));
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { param, (int)paramValue });
		break;
		// Unhandled parameter (should not occur).
	default:
		strTemp.Format(L"Unknown parameter %.2X, setting aborted.", param);
		IncludeTextMessage(strTemp);
		sts = PCANTP_ERROR_WRONG_PARAM;
		break;
	}
	// Outputs the new parameter value.
	OnBnClickedButtonGet();
}


/// <summary>
/// Event called when Dialog is destroyed
/// </summary>
void CPCanIsoTpExampleDlgParameters::PostNcDestroy()
{
	CDialogEx::PostNcDestroy();
	delete this; // Free the memory 
}


/// <summary>
/// Event called when Button Get is clicked
/// </summary>
void CPCanIsoTpExampleDlgParameters::OnBnClickedButtonGet()
{
	TPCANTPParameter param = 0;
	TPCANTPStatus sts = 0;
	UINT32 iBuf = 0;
	CString msg = L"";
	char strBuf[256] = {'\0'};

	// Checks selection is valid.
	if (comboBoxParameter.GetCurSel() == CB_ERR)
		return;

	// Gets selected parameter
	param = (TPCANTPParameter)(comboBoxParameter.GetItemData(comboBoxParameter.GetCurSel()));

	switch (param)
	{
		// Retrieves the API version.
	case PCANTP_PARAM_API_VERSION:
		sts = CANTP_GetValue(*m_pctpHandle, param, &strBuf, 256);
		if (sts == PCANTP_ERROR_OK)
		{
			IncludeTextMessage(L"ISO-TP API version:" + (CString)strBuf);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, strBuf, param);
		break;
		// Reads the ISO-TP BlockSize (BS) parameter (number of Consecutive Frame between Flow Control frames).
	case PCANTP_PARAM_BLOCK_SIZE:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) 
		{
			msg.Format(L"ISO-TP Block Size parameter is %d (%.2Xh).", iBuf, iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads if CAN DATA Padding is enabled (if enabled, all segmented CAN frames have a DLC of 8).
	case PCANTP_PARAM_CAN_DATA_PADDING:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"CAN Data Padding is %s (%d).", (iBuf == PCANTP_CAN_DATA_PADDING_NONE) ? L"disabled" : L"enabled", iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads the channel's state.
	case PCANTP_PARAM_CHANNEL_CONDITION:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			switch (iBuf)
			{
			case PCANTP_CHANNEL_AVAILABLE:
				msg.Format(L"Channel %.2Xh is available (%d).", *m_pctpHandle, iBuf);
				IncludeTextMessage(msg);
				break;
			case PCANTP_CHANNEL_UNAVAILABLE:
				msg.Format(L"Channel %.2Xh is unavailable (%d).", *m_pctpHandle, iBuf);
				IncludeTextMessage(msg);
				break;
			case PCANTP_CHANNEL_OCCUPIED:
				msg.Format(L"Channel %.2Xh is occupied (%d).", *m_pctpHandle, iBuf);
				IncludeTextMessage(msg);
				break;
			default:
				msg.Format(L"Channel %.2Xh is in an unknown state (%d).", *m_pctpHandle, iBuf);
				IncludeTextMessage(msg);
				break;
			}
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads if Debug mode is enabled (if enabled, CAN Tx/Rx frames are echoed on console output).
	case PCANTP_PARAM_DEBUG:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"Debug mode 'CAN frames on console output' is %s (%d).",
				(iBuf == PCANTP_DEBUG_NONE) ? L"disabled" : L"enabled", iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads if Message Pending Mode is enabled 
		//  (if enabled, CAN ISO-TP messages with type PCANTP_MESSAGE_INDICATION 
		//  can be read when the first frame of a segmented message is received).
	case PCANTP_PARAM_MSG_PENDING:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"Notifications of incoming CAN-ISO-TP messages are %s (%d).",
				(iBuf == PCANTP_MSG_PENDING_HIDE) ? L"disabled" : L"enabled", iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads the padding value used when "CAN DATA Padding" is enabled.
	case PCANTP_PARAM_PADDING_VALUE:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"Value for 'CAN Data Padding' is %.2Xh (%d)", iBuf, iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads the receive-event handle (if receive-event is disabled, 0 is returned).
	case PCANTP_PARAM_RECEIVE_EVENT:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"Receive event is %s (event handle is %Xh).",
				(iBuf == 0) ? L"disabled" : L"enabled", iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads the ISO-TP SeparationTime (STmin) parameter 
		//  (minimum time to wait between Consecutive Frames transmission).
	case PCANTP_PARAM_SEPARATION_TIME:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK)
		{
			if (iBuf < 0x80) {
				msg.Format(L"ISO-TP Separation Time (STmin) is %dms (%.2Xh).", iBuf, iBuf);
				IncludeTextMessage(msg);
			}
			else if (iBuf > 0xF0 && iBuf < 0xFA) {
				msg.Format(L"ISO-TP Separation Time (STmin) is %ds (%.2Xh).", (iBuf - 0xF0) * 100, (iBuf - 0xF0) * 100);
				IncludeTextMessage(msg);
			}
			else
			{
				msg.Format(L"ISO-TP Separation Time (STmin) uses a reserved value of ISO 15765 (%.2Xh).", iBuf, iBuf);
				IncludeTextMessage(msg);
			}
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads the ISO-TP FC.Wait frame transmissions (N_WFTMax) parameter 
		//  (maximum number of consecutive Flow Control frames with the Wait status after which transmission is aborted).
	case PCANTP_PARAM_WFT_MAX:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"Maximum number of FC.Wait frame transmissions (N_WFTMax) is %d.", iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads the ISO-TP default priority value for normal fixed, mixed and enhanced addressing
	case PCANTP_PARAM_J1939_PRIORITY:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"The default priority value for normal fixed, mixed and enhanced addressing is %d.", iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Reads the ISO-TP default DLC to use when transmitting messages with CAN FD
	case PCANTP_PARAM_CAN_TX_DL:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"The default DLC to use when transmitting messages with CAN FD is %d.", iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;
		// Generic reading request of a parameter (should not occur).
	default:
		sts = CANTP_GetValue(*m_pctpHandle, param, &iBuf, sizeof(UINT32));
		if (sts == PCANTP_ERROR_OK) {
			msg.Format(L"Unknown parameter '%d' is %Xh", param, iBuf);
			IncludeTextMessage(msg);
		}
		CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)iBuf, param });
		break;

	}
}

/// <summary>
/// Includes a new line of text into the information ListBox
/// </summary>
/// <param name="p_strMsg">Text to be included</param>
void CPCanIsoTpExampleDlgParameters::IncludeTextMessage(CString p_strMsg) {
	// Adds a new line of information to the multiline EditBox
	listBoxParamInfo.AddString(p_strMsg + L"\r\n");
	// Ensure that the last item is visible.
	listBoxParamInfo.SetCurSel(listBoxParamInfo.GetCount() - 1);
}

/// <summary>
/// Event handler called when the selection of the comboBox "Parameters" is changed.
/// </summary>
void CPCanIsoTpExampleDlgParameters::OnCbnSelchangeComboParam()
{
	TPCANTPParameter param;
	BOOL isRadioEnabled, isNudEnabled, isSetEnabled, isGetEnabled;
	UINT32 nudMaxValue, nudMinValue, nudDefaultValue;

	nudMinValue = 0x00;
	nudMaxValue = 0xFF;
	nudDefaultValue = 0x00;
	isRadioEnabled = false;
	isNudEnabled = false;
	isSetEnabled = false;
	isGetEnabled = false;

	if ((comboBoxParameter.GetCurSel() != CB_ERR) && isConnected())
	{
		isGetEnabled = isConnected();
		// Activates/deactivates controls according to the selected parameter 
		param = (TPCANTPParameter)(comboBoxParameter.GetItemData(comboBoxParameter.GetCurSel()));
		switch (param)
		{
		case PCANTP_PARAM_API_VERSION:
			isGetEnabled = true;
			break;
		case PCANTP_PARAM_BLOCK_SIZE:
			isNudEnabled = true;
			isSetEnabled = isConnected();
			break;
		case PCANTP_PARAM_CAN_DATA_PADDING:
			isRadioEnabled = true;
			isSetEnabled = isConnected();
			break;
		case PCANTP_PARAM_CHANNEL_CONDITION:
			isGetEnabled = true;
			break;
		case PCANTP_PARAM_DEBUG:
			isRadioEnabled = true;
			isSetEnabled = isConnected();
			break;
		case PCANTP_PARAM_MSG_PENDING:
			isRadioEnabled = true;
			isSetEnabled = isConnected();
			break;
		case PCANTP_PARAM_PADDING_VALUE:
			isNudEnabled = true;
			isSetEnabled = isConnected();
			break;
		case PCANTP_PARAM_J1939_PRIORITY:
			isNudEnabled = true;
			nudMaxValue = 0x07;
			nudDefaultValue = 0x06;
			isSetEnabled = isConnected();
			break;
		case PCANTP_PARAM_CAN_TX_DL:
			isNudEnabled = true;
			nudMaxValue = 0x0F;
			nudMinValue = 0x08;
			nudDefaultValue = 0x08;
			isSetEnabled = isConnected();
			break;
		case PCANTP_PARAM_RECEIVE_EVENT:
			break;
		case PCANTP_PARAM_SEPARATION_TIME:
			isNudEnabled = true;
			isSetEnabled = isConnected();
			break;
		case PCANTP_PARAM_WFT_MAX:
			isGetEnabled = true;
			isNudEnabled = true;
			isSetEnabled = true;
			nudMaxValue = 0xFFFF;
			break;
		}
	}

	// Activates/deactivates controls
	buttonParamGet.EnableWindow(isGetEnabled);
	buttonParamSet.EnableWindow(isSetEnabled);
	radioButtonParamActive.EnableWindow(isRadioEnabled);
	radioButtonParamInactive.EnableWindow(isRadioEnabled);
	editParamValue.EnableWindow(isNudEnabled);
	numericUpDownParamValue.EnableWindow(isNudEnabled);
	
	numericUpDownParamValue.SetBase(16);
	numericUpDownParamValue.SetRange32(nudMinValue, nudMaxValue);
	numericUpDownParamValue.SetPos32(nudDefaultValue);
}

/// <summary>
/// States if an ISO-TP channel is currently connected.
/// </summary>
/// <returns>true if a channel is connected.</returns>
bool CPCanIsoTpExampleDlgParameters::isConnected()
{
	return PCANTP_ERROR_NOT_INITIALIZED != CANTP_GetStatus(*m_pctpHandle);
}

/// <summary>
/// Event handler called when button "Parameters > Status" is clicked.
/// </summary>
void CPCanIsoTpExampleDlgParameters::OnBnClickedButtonStatus()
{
	TPCANTPStatus stsResult;
	CString errorName;
	CString strStatus;

	// Gets the current BUS status of a PCAN Channel.
	stsResult = CANTP_GetStatus(*m_pctpHandle);
	CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, stsResult);
	// Formats on status
	switch (stsResult)
	{
	case PCANTP_ERROR_NOT_INITIALIZED:
		errorName = L"PCANTP_ERROR_NOT_INITIALIZED";
		break;
	case PCANTP_ERROR_BUSLIGHT:
		errorName = L"PCANTP_ERROR_BUSLIGHT";
		break;
	case PCANTP_ERROR_BUSHEAVY: // TPCANTPStatus.PCANTP_ERROR_BUSWARNING
		errorName = L"PCANTP_ERROR_BUSHEAVY";
		break;
	case PCANTP_ERROR_BUSOFF:
		errorName = L"PCANTP_ERROR_BUSOFF";
		break;
	case PCANTP_ERROR_OK:
		errorName = L"PCANTP_ERROR_OK";
		break;
	default:
		errorName = L"See Documentation";
		break;
	}
	// Displays Message
	strStatus.Format(L"Channel status: %s (%Xh)", errorName, stsResult);
	IncludeTextMessage(strStatus);
}


/// <summary>
/// Event handler called when button "Parameters > Reset" is clicked.
/// </summary>
void CPCanIsoTpExampleDlgParameters::OnBnClickedButtonReset()
{
	TPCANTPStatus sts;

	// Resets the receive and transmit queues of a PCAN Channel.
	sts = CANTP_Reset(*m_pctpHandle);
	CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts);
	if (sts == PCANTP_ERROR_OK)
	{
		IncludeTextMessage(L"Receive and transmit queues successfully reset.");
	}
	else
	{
		IncludeTextMessage(L"ERROR during receive and transmit queues reset.");
	}
}


/// <summary>
/// Event handler called when button "Parameters > Clear Information" is clicked.
/// </summary>
void CPCanIsoTpExampleDlgParameters::OnBnClickedButtonClear()
{
	listBoxParamInfo.ResetContent();
}


/// <summary>
/// Event handler called when button "Parameters > Version" is clicked.
/// </summary>
void CPCanIsoTpExampleDlgParameters::OnBnClickedButtonVersion()
{
	TPCANTPStatus sts = 0;
	char strTemp[256] = { '\0' };

	//Gets the vesion of the ISO-TP API
	sts = CANTP_GetValue(PCANTP_NONEBUS, PCANTP_PARAM_API_VERSION, &strTemp, 256);
	CPCanIsoTpUtils::checkCanTpStatus(PCANTP_NONEBUS, sts, strTemp, PCANTP_PARAM_API_VERSION);
	if (sts == PCANTP_ERROR_OK)
	{
		IncludeTextMessage(L"API Version: " + (CString)strTemp);
	}
}
